<?cs # vim: set syntax=html :?>

<?cs include:"doctype.cs" ?>

<html>

<head>
   <?cs # Note that the title here is used to determine if global dashboards should retry, so don't change the html! See DBDremoteIguanaRequestJob.cpp ?>
   <title>Starting Iguana</title>
   <?cs include:"browser_compatibility.cs" ?>
   <?cs include:"styles.cs" ?>
   <link rel="stylesheet" type="text/css" href="<?cs var:skin("iguana_configuration.css") ?>" />

   <script type="text/javascript" src="/js/jquery-1.11.2/jquery-1.11.2.min.js"></script>
   <script type="text/javascript" src="<?cs var:iguana_version_js("/js/ajax/ajax.js") ?>"></script>
   <script type="text/javascript" src="<?cs var:iguana_version_js("/js/utils/startup_status.js") ?>"></script>
   
<script type="text/javascript">

   var displayLoginButtonWhenComplete = function() {
      //show the login button
      document.getElementById('load_complete_button').style.display = 'inline';
      document.getElementById('starting_iguana_label').innerHTML = 'Iguana Started.';
   }

   function doOnLoaded() {
      var CurrentData = '<?cs var:js_escape(status) ?>';
      var Updater = new StartupStatusUpdater();
      Updater.init(CurrentData, "startup_status_panel", displayLoginButtonWhenComplete, null, false);
      Updater.start();
   }

</script>


</head>

<body class="tableft" onload="doOnLoaded();" >

<div id="header">

<script type="text/javascript" src="<?cs var:iguana_version_js("/skinningwindow.js") ?>"></script>
<script type="text/javascript" src="<?cs var:iguana_version_js("/js/ajax/ajax.js") ?>"></script>

<header>
   <div>
     <img src="/images/iguana_logo.png" class="iguana_logo"/>
   </div>
</header>

</div>

<!-- START MAIN CONTAINER -->
<div id="main">

   <table id="iguana">
      <tr>
         <td id="cookie_crumb">
            Iguana Startup
         </td>
      </tr>

      <tr><td id="dashboard_body" style="height: 225px;">
      <center>

            <h2><div id="starting_iguana_label"> Starting Iguana...</div> </h2>
	    <div id="startup_status_panel">
	    </div>
            <table>
            <tr>
               <td>
	            <form name="continue_form" action="/login.html" method="POST">
                  <?cs each: SavedVariable = Saved ?>
                     <input name="<?cs var:"Saved." + name(SavedVariable) + ".Name" ?>" type="hidden" value="<?cs var:html_escape(SavedVariable.Name) ?>" />
                     <input name="<?cs var:"Saved." + name(SavedVariable) + ".Value" ?>" type="hidden" value="<?cs var:html_escape(SavedVariable.Value) ?>" />
                  <?cs /each ?>
                  <input name="RedirectLocation" type="hidden" value="<?cs var:html_escape(RedirectLocation) ?>" />
	               <a id="load_complete_button" class="action-button blue" style="display: none;" href="#" onclick="document.continue_form.submit()">
                     Continue To Login
                  </a>
               </form>
	            </td>
             </tr>
             </table>

         </center>
         </td>
      </tr>

   </table>
</div>
<!-- END MAIN CONTAINER -->


<!-- START SIDE PANEL -->
<div id="side_panel">
   
   <table id="side_table">
      <tr>
         <th id="side_header">
            Page Help
         </th>
      </tr>
      <tr>
		<td id="side_body">		
					<?cs if:UsingDefaults ?>
                        <h4 class="side_title">Default Login Settings:</h4>
                        <b>Username:</b> <?cs var:html_escape(DefaultUserName) ?><br>
                        <b>Password:</b> <?cs var:html_escape(DefaultPassword) ?><br><br>
                        This can be changed through the Settings Tab.
                     <?cs else ?>
                     	<h4 class="side_title">Forgot your password?</h4>
                        <a href="<?cs var:help_link('iguana_resetting_password_4.0') ?>">Reset your password.</a>
                     <?cs /if ?>

		</td>
	  </tr>
	             <tr>
         <td id="side_body">
            <h4 class="side_title">Overview</h4>
	     <p>
	 This page displays the informational messages generated by Iguana when it starts up. 
	 </p> 
	 </tr>
	        <tr>
         <td class="side_item">
            <h4 class="side_title">Help Links</h4>
            
            <ul class="help_link_icon">
            	<li>
            	<a href="<?cs var:help_link('iguana4_accessing_web_interface') ?>" target="_blank">Accessing the Web Interface</a>
            	</li>
            </ul>
         </td>
      </tr>
	</table>

</div>
<!-- END SIDE PANEL -->

</body>

</html>

