/** @license
 * Copyright (c) 2010-2013 iNTERFACEWARE Inc.  All rights reserved.
 */
// require('utils/local_storage.js')
var isIE8 = $.browser.msie && +$.browser.version === 8;
if (!isIE8) {  // local storage can't be run on IE 8 because IE 8 requires a domain (can't run local file with localStorage support)
module("Local_Storage_Tests", {
    setup: function() {
       this.storage = new ifware.LocalStorage();
        this.storage.clear();
    },
    teardown : function() {
       delete this.storage;
    }
});

test('Local storage can be cleared.', 1, function() {  // Recommend putting this test first since clear is used in setup.

    // arrange with two values just incase clear manages to clear one correctly, but not other.
    this.storage.set('k', 'k');
    this.storage.set('z', 'z');

    this.storage.clear();

    deepEqual(null, this.storage.get('k') || this.storage.get('y'), 'Clear works!');
});

test('Local storage can set and get a value.', 1, function() {
    var expected = 'value';

    this.storage.set('test', expected, 1);
    var value = this.storage.get('test');

    deepEqual(value, expected, 'What was inserted came out the same');
});

test('Local storage returns null if value doesnt exist.', 1, function() {
    var value = this.storage.get('test');

    deepEqual(value, null, 'No matching key returns null.');
});

test('Local storage attempts to clear expired data on set/get/removeItem.', 3, function() {
    var expected = null;
    var proxyAssert = function() { ok(true, 'Clear expired was called.')};
    $(this.storage).bind(this.storage.events.clearExpired, proxyAssert);

    this.storage.get('test');
    this.storage.set('test', 'value');
    this.storage.remove('test');

    //cleanup
    try {
        $(this.storage).unbind(this.storage.events.clearExpired, proxyAssert);
    } catch(ex){}; // suppress known jquery bug: http://forum.jquery.com/topic/javascript-error-when-unbinding-a-custom-event-using-jquery-1-4-2
});

test('Local storage clears expired data properly.', 1, function() {
    var msInADay = 24*60*60*1000;
    this.storage.set('test', 'value', 1);
    var clock = sinon.useFakeTimers(msInADay+1);

    deepEqual(null, this.storage.get('test'), 'local storage successfully expired stale data.');

    //cleanup
    clock.restore();
});

test('Local storage can stores/gets objects.', 1, function() {
    var o = { p: 'd', inner: { ip: 'id' } };

    this.storage.setObject('testObj', o);

    deepEqual(this.storage.getObject('testObj'), o);
});

test("Local storage can store things in different bins", 4, function() {
    var storage1 = ifware.LocalStorage('bin1');
    var storage2 = ifware.LocalStorage('bin2');

    var obj = { prop1: 'property 1'};
    var obj2 = { prop1: 'awesome', inner: { other: 'other awesome'}};

    storage1.set('key', 'val');
    storage1.setObject('objKey', obj);

    storage2.set('key', 'awesome');
    storage2.setObject('objKey', obj2);

    deepEqual(storage1.get('key'), 'val');
    deepEqual(storage2.get('key'), 'awesome');

    deepEqual(storage1.getObject('objKey'), obj);
    deepEqual(storage2.getObject('objKey'), obj2);
});

test("Test static method 'setOrGetState'", 3, function() {
    var o = { myState: false, x: true };
    var storage = ifware.LocalStorage('x');
    ifware.LocalStorage.setOrGetState(o, 'myState', true, storage);

    equal(storage.get('myState'), true);
    equal(o.myState, true);

    // set x to false and expect it not to revert back to the default (true)
    ifware.LocalStorage.setOrGetState(o, 'x', false, storage);
    o.x = true;  // set it back to default simulating page refresh
    equal(ifware.LocalStorage.setOrGetState(o, 'x', undefined, storage), false);

});
}